package com.example.osupdatesample;

import com.example.osupdatesample.R;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.storage.StorageManager;
import android.util.Log;
import android.util.Xml;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

public class MainActivity extends Activity {
	private static final String TAG = "OSUpdateSample";

	private static final String HT_UPDATE_PACKAGE = "jp.casio.ht.osupdateservice";
	private static final String HT_UPDATE_CLASS = "jp.casio.ht.osupdateservice.StartUpdate";

	private static String INTERNAL_STORAGE;
	private static String mOSImageFilePath;

    private static String mResult;	// OS Update Result

	// receiver
	private UpdateFinishReceiver updateFinishReceiver;
	private IntentFilter intentFilter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
   	    setContentView(R.layout.activity);

   	    //
		intentFilter = new IntentFilter("jp.casio.ht.osupdateservice.finishupdate");
		updateFinishReceiver = new UpdateFinishReceiver();
		registerReceiver(updateFinishReceiver, intentFilter);

   	    // internal storage path
		try {
			INTERNAL_STORAGE = Environment.getExternalStorageDirectory().getCanonicalPath();
		} catch (IOException e) {
			e.printStackTrace();
		}

		// widget
   		(findViewById(R.id.start)).setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				startSystemUpdate();
				finish();
			}
		});

		// check launch intent
		Intent intent = getIntent();
		if (intent == null) {
		    return;
		}
		mResult = null;
		if (intent.getExtras() != null) {
			mResult = intent.getExtras().getString("result");
		}
    }

	@Override
    public void onResume() {
		super.onResume();

		// init widget
		Button btnStart = (Button)findViewById(R.id.start);
		TextView pfufile = (TextView)findViewById(R.id.update_file);
		TextView msg = (TextView)findViewById(R.id.messagelog);

		// check package for OS Update intent
		PackageManager pm = getPackageManager();
		PackageInfo pi = null;
		try {
			pi = pm.getPackageInfo(HT_UPDATE_PACKAGE, PackageManager.GET_META_DATA);
		} catch (NameNotFoundException e) {
			msg.setText(e.toString());
		}
		if (pi == null || INTERNAL_STORAGE == null) {
			// no OS Update Service
			btnStart.setEnabled(false);
			return;
		}
		String msgtext = "";
		if (mResult != null) {
			msgtext = "OS Update Result: " + mResult + "\n\n";
		}

		// version
		String osVersion = getCurrentOSVersion();

		// status
		msg.setText(msgtext + "Current Ver: " + osVersion + "\n\n" + lastUpdateInfo());

		// OS image file
		// full ota in internal storage
		mOSImageFilePath = INTERNAL_STORAGE + File.separator + "ETL10-Vxxx-EN_xx.ota";
		// full ota in external storage
//		mOSImageFilePath = "ETL10-Vxxx-EN_xx.ota";
		// diff ota in internal storage
//		mOSImageFilePath = INTERNAL_STORAGE + File.separator + "ETL10-Vxxx-EN_xx-from-Vxxx-EN_xx.ota";
		// diff ota in external storage
//		mOSImageFilePath = "ETL10-Vxxx-EN_xx-from-Vxxx-EN_xx.ota";

		if(isOSImageFile(mOSImageFilePath)){
			// ok
			pfufile.setText(mOSImageFilePath);
			btnStart.setEnabled(true);
		} else {
            Log.d(TAG, "this is not ET-L10 OS image.");
			btnStart.setEnabled(false);
		}

    }

	@Override
	public void onPause() {
		super.onPause();
	}

	@Override
	public void onDestroy(){
    	super.onDestroy();

    	try{
    		unregisterReceiver(updateFinishReceiver);
		} catch (Exception e){
    		Log.d(TAG, "already unregistered.");
		}
	}

    private String getCurrentOSVersion(){
    	String version = "";
		String[] osVersions = Build.DISPLAY.split("_");
		if(osVersions.length < 3){
			return null;
		}

		// 2nd is model
		if(osVersions[1].equals("EN")){
			// EN model
		} else if(osVersions[1].equals("CN")){
			// CN model
		} else {
			return null;
		}

		// 3rd is version
		version = osVersions[1] + "_" + osVersions[2];

		return version;
	}

	private boolean isOSImageFile(String filePath){
    	File file = new File(filePath);
  		String fileName = file.getName();
		String curOSVersion = getCurrentOSVersion();
		if ((fileName.startsWith("ETL10")) && (fileName.toLowerCase().endsWith(".ota"))) {
			// ET-L10 OS image
			if (fileName.contains("from")) {
				// diff ota
				if (curOSVersion != null) {
					String osFileNameWithoutExt = fileName.substring(0, fileName.lastIndexOf("."));
					if (osFileNameWithoutExt.endsWith(curOSVersion)) {
						// diff ok
						return true;
					}
				}
			} else {
				// full ok
				return true;
			}
		}
		return false;
	}

	private void startSystemUpdate() {
		Log.d(TAG, "start system update: " + mOSImageFilePath);

		// start unattend update
        Intent intent = new Intent(Intent.ACTION_MAIN);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
		intent.setClassName(HT_UPDATE_PACKAGE, HT_UPDATE_CLASS);

        // set update file
        Uri uri = Uri.parse(mOSImageFilePath);
		intent.setData(uri);
		startActivity(intent);
    }

    private String lastUpdateInfo() {
		String resultxml = INTERNAL_STORAGE + "/Android/data/" + HT_UPDATE_PACKAGE + "/files/result.xml";
		File file = new File(resultxml);
		if (!file.exists() || !file.canRead()) {
	        Log.d(TAG, resultxml + ": not exist.");
			return "";
		}
    	XmlPullParser xpp = null;
		BufferedReader br = null ;
		try {
		    br = new BufferedReader(new FileReader(resultxml));
		} catch (FileNotFoundException e) {
            Log.e(TAG, "FileNotFoundException: " + e);
		}
		if (br != null) {
				xpp = Xml.newPullParser() ;
		    try {
		    	xpp.setInput(br);
		    } catch (XmlPullParserException e) {
		        Log.e(TAG, "XmlPullParserException: " + e);
		    }
		}
		String info = "";
		try {
		    for (int e = xpp.getEventType(); e != xpp.END_DOCUMENT; e = xpp.next()) {
				if (e == xpp.START_TAG) {
				    String name = xpp.getName();
				    if (name.equals("update")) {
				    	xpp.nextTag();
				    	info += "*** Last Update Results ***\n";
				    } else {
						String text = xpp.nextText();
						Log.d(TAG, "log: " + name + " [" + text + "]");
						info += "[" + name + "]: [" + text + "]\n";
				    }
				}
		    }
		    br.close();
		} catch (XmlPullParserException e) {
            Log.e(TAG, "XmlPullParserException: " + e);
            info += e.getMessage();
		} catch (IOException e) {
            Log.e(TAG, "IOException: " + e);
            info += e.getMessage();
		}
		return info;
    }
}
