package com.example.osupdatesample;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;

public class UpdateFinishReceiver extends BroadcastReceiver {
	private static final String TAG = "UpdateFinishReceiver";

	@Override
	public void onReceive(Context context, Intent intent) {
		Bundle bundle = intent.getExtras();
		// finish log
		Log.i(TAG, intent.getAction() + " received, Result: " + bundle.getString("result") + " Current Ver: " + Build.DISPLAY);

		Intent mainActivity = new Intent(context, MainActivity.class);
		mainActivity.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
		mainActivity.putExtra("result", bundle.getString("result"));
		context.startActivity(mainActivity);
	}
}
