package jp.casio.ht.intent.scansample.symbolscan;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Switch;
import android.widget.TextView;

public class MainActivity extends AppCompatActivity {

    private static TextView mTextView1, mTextView2, mTextView3;
    private static Switch mSwitch1, mSwitch2, mSwitch3;
    private static ScannerLibrary mScanLib;
    private static ScanResultReceiver mScanResultReceiver;

    private ScannerLibrary getmScanLib() {
        if (mScanLib == null) {
            mScanLib = new ScannerLibrary(this);
        }
        return mScanLib;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        //1. Init Scanner
        mScanLib = new ScannerLibrary(this);
        mScanResultReceiver = new ScanResultReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCANRESULT");
        registerReceiver(mScanResultReceiver, filter);

        mTextView1 = (TextView) findViewById(R.id.textView1);
        mTextView2 = (TextView) findViewById(R.id.textView2);
        mTextView3 = (TextView) findViewById(R.id.textView3);
        mSwitch1 = (Switch) findViewById(R.id.switch1);
        mSwitch2 = (Switch) findViewById(R.id.switch2);
        mSwitch3 = (Switch) findViewById(R.id.switch3);


        //EAN13
        mSwitch1.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (mSwitch1.isChecked() == true) {
                    getmScanLib().setSymbologyEnable(10, 0);
                } else {
                    getmScanLib().setSymbologyEnable(10, 1);
                }
                return false;
            }
        });

        //QR
        mSwitch2.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (mSwitch2.isChecked() == true) {
                    getmScanLib().setSymbologyEnable(17, 0);
                } else {
                    getmScanLib().setSymbologyEnable(17, 1);
                }
                return false;
            }
        });

        //PDF417
        mSwitch3.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (mSwitch3.isChecked() == true) {
                    getmScanLib().setSymbologyEnable(15, 0);
                } else {
                    getmScanLib().setSymbologyEnable(15, 1);
                }
                return false;
            }
        });
    }


    @Override
    protected void onResume() {
        super.onResume();

        //2. Several Settings
        getmScanLib().openScanner();
        getmScanLib().setDefaultAll();
        getmScanLib().setSymbologyEnable(99, 0);
        getmScanLib().setSymbologyEnable(10, 1);
        getmScanLib().setSymbologyEnable(15, 1);
        getmScanLib().setSymbologyEnable(17, 1);
        getmScanLib().setTriggerKeyTimeout(3);//3seconds
        getmScanLib().setOutputType(1);//Broadcast

        mSwitch1.setChecked(true);
        mSwitch2.setChecked(true);
        mSwitch3.setChecked(true);
    }

    @Override
    protected void onPause() {
        //4. Deinit Scanner
        getmScanLib().closeScanner();
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        //4. Deinit Scanner
        unregisterReceiver(mScanResultReceiver);
        mScanLib = null;
        super.onDestroy();
    }

    //3. Get Scan Result
    public static class ScanResultReceiver extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.SCANRESULT")) {
                final String scanResult = intent.getStringExtra("value");
                final int type = intent.getIntExtra("type", 0);

                if (scanResult.length() > 0) {
                    mTextView1.setText(scanResult);
                    mTextView3.setText(String.valueOf(scanResult.length()));
                    switch (type) {
                        case 100:
                            mTextView2.setText("EAN13");
                            break;
                        case 115:
                            mTextView2.setText("QR code");
                            break;
                        case 114:
                            mTextView2.setText("PDF417");
                            break;
                        default:
                            mTextView2.setText("Not defined");
                            break;
                    }
                } else {
                    mTextView1.setText("");
                    mTextView2.setText("");
                    mTextView3.setText("");
                }
            }
        }
    }
}
