package jp.casio.ht.intent.scansample.symbolscan;

import android.content.Context;
import android.content.Intent;

public class ScannerLibrary{
    private Context mContext;

    public ScannerLibrary(Context context) {
        mContext = context;
    }

    public static class INTENT {
        public static final String SCANNER_OPENCLOSE = "android.intent.action.BARCODESCAN";
        public static final String SCANNER_DEFAULTALL = "android.intent.action.DEFAULT";
        public static final String SCANNER_ENABLE_SYMBOLOGY = "android.intent.action.ENABLESYMBOLOGIES";
        public static final String SCANNER_OUTPUT_TYPE = "android.intent.action.BARCODEOUTPUT";
        public static final String SCANNER_TRIGGERKEY_TIMEOUT = "android.intent.action.TIMEOUT";
    }

    public void openScanner() {
        if (mContext != null) {
            Intent intent = new Intent(INTENT.SCANNER_OPENCLOSE);
            intent.putExtra(ScannerLibrary.INTENT.SCANNER_OPENCLOSE, true);
            mContext.sendBroadcast(intent);
        }
    }

    public void closeScanner() {
        if (mContext != null) {
            Intent intent = new Intent(ScannerLibrary.INTENT.SCANNER_OPENCLOSE);
            intent.putExtra(ScannerLibrary.INTENT.SCANNER_OPENCLOSE, false);
            mContext.sendBroadcast(intent);
        }
    }

    public void setDefaultAll() {
        if (mContext != null) {
            Intent intent = new Intent(INTENT.SCANNER_DEFAULTALL);
            mContext.sendBroadcast(intent);
        }
    }

    public void setOutputType(int outputType) {
        if (mContext != null) {
            Intent intent = new Intent(INTENT.SCANNER_OUTPUT_TYPE);
            intent.putExtra(ScannerLibrary.INTENT.SCANNER_OUTPUT_TYPE, outputType);
            mContext.sendBroadcast(intent);
        }
    }

    public void setTriggerKeyTimeout(int triggerKeyTimeout) {
        if (mContext != null) {
            Intent intent = new Intent(INTENT.SCANNER_TRIGGERKEY_TIMEOUT);
            intent.putExtra(ScannerLibrary.INTENT.SCANNER_TRIGGERKEY_TIMEOUT, triggerKeyTimeout);
            mContext.sendBroadcast(intent);
        }
    }

    public void setSymbologyEnable(int symbologyID, int enable) {
        if (mContext != null) {
            Intent intent = new Intent(INTENT.SCANNER_ENABLE_SYMBOLOGY);
            intent.putExtra("symbologies", symbologyID);
            if (enable == 1) {
                intent.putExtra("enable", true);
            } else if (enable == 0) {
                intent.putExtra("enable", false);
            }
            mContext.sendBroadcast(intent);
        }
    }
}
